define([
    'backbone',
    'Layout',
    'modules/form/question-view',
    'modules/form/question-model',
],
function(Backbone, Layout, QuestionView, QuestionModel) {
    'use strict';

    describe('Textarea Question View', function() {
        var modelJSON = {
            id: 'unit-test-textarea',
            type: 'textarea',
            label: 'Unit Test Textarea',
            required: false,
            idPrefix: '',
            value: '',
            maxlength: 100,
            placeholder: '',
        };

        var view;
        var $view;
        var layout = new Layout();
        layout.render();

        beforeEach(function() {
            spyOn(QuestionView.prototype, 'addFormValidationRules');

            view = new QuestionView({model: new Backbone.Model(modelJSON)});

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('controls the text counter display', function() {
            $view.find('textarea').val('word')
                .trigger('keyup');
            expect($view.find('.textarea-counter').text()).toEqual('96 characters remaining');
        });
    });
});
